---
title: "Branch & Merge on PLM data"
categories: 
  - "software-solutions"
draft: true
---

Branching is a common concept in software development, it allows to work on alternative versions of a software configuration before potentially merging back the changes to the initial configuration.

<figure>

![](images/branchmergesoftware.png)

<figcaption>

Code repository (Git) Branches and Merges

</figcaption>

</figure>

If we take any type of information, whether it is a document, a mechanical part design, an electronic board design, or any other thing that is part of your product (could be a service), the branch and merge concept is very appealing. Some CAD system may offer it as a feature.

https://youtu.be/QHEKB2tO4-8

## Wait a minute !

I have been working with software repositories for about 15 years. SVN and GIT mainly. I have always benefited from Branching and merging, but as exciting as it sounds, it can't be always as smooth as you think. The key value of the branch & merge feature is finding differences at least in order to merge. Let's see the two concept separately.

## Branching

Branching seems very easy. It's basically a copy. You take a code repository and you copy it. Same for cad you save your assembly, create a copy of the folder and "voilà" you branched. Well that's easy when you work in a blob where you control everything. PLM is a graph where everything is connected. Therefore, when you branch something, how far do you branch? how much of the graph do you copy?

## Merging

As I mentioned previously, merging is about knowing the difference between states of a similar graph of information. For software source code usually the comparaison is done line by line and can be easily resolved 95% of the time. But have you tried merging XML? any structured format require specific diffing algorithm. If this can already be a problem for software source code, imaging how complicated it is to run a merge operation of a graph of heterogenous data?
