---
title: "Graph DB for PLM : Schema evolution"
date: 2021-11-04
categories: 
  - "databases"
coverImage: "databaseFixedSchema.jpg"
---

One of the characteristics of PLM is the need for flexible data models. You can argue that and tell me that everyone should follow standards so you don't have to build your own model and you don't have to make any change. But believing that is letting Excel or other spreadsheets win. Rely on a fixed schema and you will get an excel based underground PLM.

Therefore once you acknowledge you need a flexible datamodel, we can cover some technological comparaison to see what is the best technology out there to support these concepts. Today I want to compare two datamodel changes one with an SQL database and the other with a graph database.

One use-case that I had to handle in the past is a change of type for a collection of objects. The customer use to have all its parts handled with a "part" class, makes sense. A classification was done to define if the part was mechanical, electronic or software. But at some point the management of software information became a lot different than the part information. Therefore we were asked to takes these softwares and migrate them to a new "software" class.

## Updating a datamodel with a SQL database

This is not an exact process because each PLM system will have its own mecanisms and tools to play with data. But basically in terms of db data manipulation you will need to do the following:

- identify the data to change = could be the result of a SQL query.
- Identify the relationships impacting this change. a Part to Document relationship will result in a new relationship between a software and a document. Your PLM system will make it easy to create the new relationship but not to transfer the existing instances of this relationship.
- Create the new table = hopefully your PLM system does that for you
- Modify the extracted data to fit with the new Software class table. (and the new relationship as well)
- Re import the data, hoping you made all the right modification to fit with the new datamodel.

## Updating a datamodel with a Graph database

For the graph database we will take neo4j as the example.

- identify the data to change = could be the result of a SQL query
- identify the relationships, to potentially update their name.
- Change the label of your nodes from Part to Software
- Change the label of the relationships you wanted to rename
- Done !

That's the beauty of it. The indexation will work then to create a new index for software and update the one for parts, but that's it. Many software editors will claim that this is too technical and never happens. Well, talk to the integrators, if they've worked with a customer for multiple years they know it happens.
