---
title: "AI powered CAD flexibility"
date: 2021-10-08
categories: 
  - "software-solutions"
coverImage: "ai.jpg"
---

Here is a short article a bit late this week about an interesting video I found about Parametric Shapes assisted with AI. This is based on a scientific paper recently published by [Elie Michel](https://www.linkedin.com/in/eliemichel/) and [Tamy Boubekeur](https://www.linkedin.com/in/tamy-boubekeur/).

https://www.youtube.com/watch?v=bkumGEkrRjs

## Exploring options

The first use I could see for this is for a product manager to explore options and variability. What if this was a bit bigger, what if this button was more on this side, what if, what if... You have a direct feedback without having to spend hours modifying and rebuilding broken CAD model. 30 years ago we would build small scale models, now we are replacing experience testing with VR. With such technology you could modify lots of mechanical aspects in just a few seconds.

## Helping AI

The other opportunity is to help AI. Many AI optimization processes will just test random options and then converge on solutions that are returning better result. But they can only do this in a range of possible solutions. Even though 3D printing has extended these possibilities, you still want AI to only explore possible solutions. With this technology you could help AI run many options that are always correct.

## PLM nightmare

What a nightmare for PLM ! This can become scary for the world of configuration management. The more we give flexibility to designers, the more consequences we can have downstream. The goal will be to make sure that the parametric rules applied on the model follow configuration management rules defined by the company. I will soon write a blog post about ["The modular way"](https://themodularway.se/) which gives great recommandation on how to implement modularity in product design. I believe this is a must before giving too much flexibility to designers.

## Other CAD/Simulation Channel

I actually got the information about this technology from a great youtube channe which covers AI, Simulation and 3D rendering: [2 minutes paper](https://www.youtube.com/c/K%C3%A1rolyZsolnai).

Have a great week-end !
