---
title: "What is Low-Code?"
date: 2021-09-15
categories: 
  - "technological-stack"
coverImage: "low-code.jpg"
---

I'm a little bit late on the marketing trend to write a post about low-code. But I was recently asked how "low-code" was [Ganister PLM](https://ganister.eu/)? I realized that you could in fact have different levels of "low-codeness".

## No-Code / Low Code

No-code means, you have an application which can be configured to your needs without writing any code. Therefore all the configuration items are manipulated through user interfaces by changing dropdown values, switching options, adding columns, etc. No development skills needed. This is no-code.

Low-code means, your application can be configured 75% - 90% ( ~ "most of" ) without any code. Then someone from your organisation requests that when someone types a description containing the word "metal", it should send an email to the a quality manager for review. This is the kind of request nobody has built a configuration for. Therefore you hook some code to a part update trigger which will then produce the expected result.

## API & Triggers

You have the easy-low-code, the complex-low code and everything in between. What makes it easy is the quality of the API and the available triggers.

### Triggers

Triggers are the event you can use to execute the custom code. These are crucial to your capacity to write code that works as expected. Triggers have to be easy to understand and you have to understand the chain of event that might result from this. What happens if in your code you update a part and your code is connected to an "onUpdate" trigger. Make sure your logic avoids loops !

### API

The API is very important. We are not talking about the API provided to create interfaces with the outside world. This is the internal API. If the provided api only allows you to interact with database objects or items and relationships, it's ok but at some point you may want to have more business logics like "UpdateBOM", "GetSupplier". They are more business oriented and help you write code faster.

## Upgrades

"No-code is someone else's code" This statement also works for low-code because you are connected to triggers and API methods from the PLM solution. It means that you somehow externalized the code of the solution. The advantage of no-code over low-code, is that the software editor knows all the possible configuration. Therefore when they upgrade the solution they make sure each configuration is taken care of. With low-code, the software editor lets you write code which creates a lot of potential configuration they haven't planned. It creates by definition more work on their side to secure the software upgrade. [@Ganister](https://ganister.eu/) that is something we spend a lot of time on, we push the limits of custom methods to make sure upgrades are working for anyone.
