---
title: "ECO Objections and remarks"
date: 2021-01-08
categories: 
  - "business-features"
  - "configuration-management"
tags: 
  - "change-management"
  - "configuration-management"
  - "eco"
  - "plm"
coverImage: "change-QP752RJ.jpg"
---

As I'm now in the business of editing PLM software with [Ganister](https://ganister.eu). I have been involved in defining what would be a correct way of dealing with configuration management (CM) focusing on the change management process. To bring my ideas to this CM process I've looked back to the objections and remarks I received. These are the main inputs I've brought to build a greater ECO.

## Releasing all at once

In a few solutions I have seen the Engineering Change Order was revising all the necessary parts and documents. At the end of the process, validating the engineering change would automatically release the new revisions. When you run a demo, this is great, usually impressive and helps explaining a smooth change management story. But some people came up to me and said: "you can't validate 10 parts at the same time". And I believe that is scary when you think about it. So some solutions separated the document validation process believing that Parts could all be released at once, once documents would be individually validated. But it means getting back to the old document centric PDM system. Validation doesn't only rely on drawings, it can contain simulation results, costs,...

I had a discussion about it with a Manager from a large PLM company and we agreed on one point. The main reason why this exists is because for a long time the PLM was managing part and document records. It was more a safe than an actual workspace. Therefore records where only entered when validation was done. And usually was done elsewhere.

Releasing everything at once is a bad idea.

## Where to draft changes?

In most ECO solution I have seen. you have a grid in which you can define what you are doing with the product structure your are changing. It usually helps understanding what the ECO is about. Like changing a quantity on a BOM relationship would be defined there.

The problem is that, when you run your process, at some point your parts will be in an editable mode. There, you can do the same changes outside the ECO grid. Update a CAD assembly for example from your CAD system. Will it update the ECO grid explaining that something changed on a BOM relationship? It should and I believe some solution already do it.

You shouldn't go into to much details about the change you are planning to do in the ECO grid. You should define what nodes will change but of course a report should be always reporting what has changed. ECO is about what can be changed, and then reporting what has changed.

## Interchangeability

The interchangeability question is still running. After my article "[Has FFF Killed?](https://plmstack.com/2020/02/26/has-fff-killed/)" Martijn Dullaart wrote [another article](https://lnkd.in/dB3Z2qF) ([linkedin comments)](https://www.linkedin.com/feed/update/urn:li:activity:6752167275521957888/) about it and I don't believe we agree much about revisions and interchangeability.

I'm trying to describe a configuration management system that does not care if a node is a part, a document, or a assembly process. Many statements start with "Part has no revision in production, this is written in CAD-Mag 1983"). I do believe we can challenge this statement by understanding why it was said in the first place.

Part Revision being interchangeable was a trick used by mechanical engineers to avoid pilling up changes at the top of an assembly. This was when part validations were done with 8 physical signatures on a piece of paper! The electronic manufacturing world and the software world (I'd have to ask the chemical industry) do not use the same rule.

But back to our ECO definition and the use of interchangeability, I still believe this is up to the company who implements it. Therefore a good change management process should allow companies to use this rule with the correct warning. **Interchangeability are always decided within a known context**.

## Part multi-usage

Part ReUse is always a tricky thing to demonstrate when we get objections. Engineers tell me : "If I have an issue on a screw and I need to replace it with another reference, than all the impacted assemblies should be revised". The limit is in terms of responsibilities. How do you make sure that all assemblies should be impacted the same way. Therefore I believe the impact should be decided for each assembly. And this could be done in a collection of ECOs, because the initial change may trigger various changes with various related projects, people, timelines,...

## Scope of an ECO

The ECO acronym often means Engineering Change Order, but more and more we are asked for Enterprise Change Orders. That is the reason why I'm trying to always think about nodes without giving them types in the first place. Later, once you validate your system you test it with real references and real types (parts, documents, ...)

Then I'm told : "but the ECO will be enormous if you have to change something impacting a whole thread from requirements to support". First, if your ECO covers the full digital thread, it is not so bad. And then I believe a full change from requirements to production and support could be split in multiple related ECOs (the top ECO being either an ECO, or a project).

This post is way longer than I anticipated. To sum up this post :

- Node release should be individual (even if it is not the first release)
- Detailed changes like BOM relationships changes should not be triggered from the ECO. Wait for the nodes to be in their new rev and editable.
- Interchangeability is still up to each company in my opinion.
- Remind yourself that when changing something, if you maximized part reused, you cannot decide the impact of a change for everyone.
- The E of ECO will have to become Enterprise or anything that doesn't refer to a specific silo like we use to.

Happy 2021 for everyone and I'll try to write more than last year !
