---
title: "What's a non-interchangeable revision in a PLM graph ?"
date: 2020-05-29
categories: 
  - "business-consulting"
coverImage: "graphDiscussion.jpg"
---

Now that we have seen [the most simple change in my previous blog post](http://plmstack.com/2020/05/12/whats-an-interchangeable-revision-in-graph/), let's talk about the revision mechanical engineers will hate : THE NON-INTERCHANGEABLE REVISION !!!

## What is it?

A non-interchangeable revision is an evolution of an item which will replace the previous revision and for which there is enough change that any assembly or container consuming this item will be impacted. Anyone managing an assembly containing this part will have to take a decision to either decide that the impact is limited and their assembly can just be "interchangeably revised" or they would have to either have a renumber or or non-interchangeable revision again.

## Running a non-interchangeable revision

### T0: A Released Structure

![released structure](images/interRevT0-1.png)

Same example as in the previous blog post, we have a released structure. Each node has a name (A,B,C,D,...) and a 2-digit version number (x.y).

### T1: We make a non-interchangeable revision

In my previous blog post I had a question about the R node. So let's try to better explain what is happening in this step.

![non interchangeable rev](images/nonInterRevT1.png)

- C gets revised with a non-interchangeable revision it becomes C2.0 and it is not released yet
- R is a new node and it consumes C2.0

The fact that R is consuming C2.0 and not C1.0 can be discussed and it is mainly a choice that should be left to the the manager of R. If this person knows it's going to take a year to release C2 and the design of R is ready for release with C1, than they may want to use the already released version knowing that it might be superseded soon. In our example we believe the manager of R wants to work on the coming revision 2.0 of C.

### T2: We Release the new Revision

Now the conclusion of this revision. Let say, you did your impact analysis but didn't take any decision on which assembly to impact. You move forward with the release of the new revision and consequently supersed the previous one which should not be used anymore.

![non interchangeable rev release](images/nonInterRevT2.png)

Now, what should happen is an marker, like a flag on any assembly consuming the previous revision (we named it obsoFlag). It should represent the fact that you have a released assembly containing a superseded part. If you were to send this to an ERP for production it should be blocked (But this doesn't mean that something sent to the ERP prior to the revision should be block).

## Pros & Cons of non-interchangeable Revision

The good thing about a non-interchangeable revision is that every assembly consuming the changed item will be noticed. So there should be no risk of human-based decision on a change which could change the behavior of your product.

The issue that I believe mechanical engineers will raise (and that's why I believe we could have both options) is that for every revision you have to take actions on all the impacted items.

## What do you think?

Combining interchangeable and non-interchangeable revision allows to have best of both worlds and re-conciliate different engineering fields. what is your take on this?
