---
title: "What's an interchangeable revision in Graph?"
date: 2020-05-12
categories: 
  - "business-consulting"
  - "business-features"
  - "configuration-management"
coverImage: "graphDiscussion2.jpg"
---

On [my french blog I wrote a blog post about some suggestions for a flexible configuration management solution](http://plm-ouvert.fr/2020/05/une-gestion-de-configuration-flexible/). I'll reproduce the article in English soon for a broader audience. Today I will cover a specific aspect of configuration management: **Creating a new interchangeable revision**. This is how it is typically handled in mechanical design. Whenever there is a change in a Part (mainly coming from a drawing) we analyse whether Fit, For and Function are maintained or not. If yes, then we create a revision, otherwise we need to create a new reference.

Let's see this behavior in a collection of graphs:

## Running an interchangeable revision

### T0: A Released Structure

Let's take a release structure. It might be a bit too much for the use case but I will reuse this structure for future use-cases.

![interchangeable revision - released structure](images/interRevT0-1.png)

### T1: Create a new Revision

We don't represent the fact that we may use an ECO to manage the creation of the new version and the release. When we create the new revision, the initial structure is still valid until we have validated this new revision and superseded the previous one. We have created in the same process a preliminary R1.0. We could assume that even if it was created after C was revised, it would make sense for it to consume C1 in case R needs to be released before the new revision of C.

![interchangeable revision - start](images/interRevT1-5.png)

### T2: Release the new Revision

Once we release the new revision, all the relationships to the previous revision have to be superseded (it's nice to keep them for tracking changes). Notice that released parents have not been revised due to the interchangeability of the revised item. We could question whether we keep or not the relationship between R1 preliminary and C1 as it was superseded before R1 was released.

![interchangeable revision - finish](images/interRevT2-4.png)

## Pros & Cons of interchangeable Revision

When you think about it, a change which keeps Fit, Form & Function, is really unlikely to happen. Historically this happened, because the revision of the drawings and the revision of parts were strongly linked and any change (even some typos) on the drawing would require to revise the part.

Making it interchangeable prevent to update the whole product structure whenever we make small drawing changes. It save a lot of time of re-validating something that hasn't changed much.

The down side is in the "much", I have talked about it in my previous article "[Has FFF killed](https://plmstack.com/2020/02/26/has-fff-killed/)?" where any one who validates an FFF decision needs to understand the consequences of a mis-judgment.

## What do you think?

Let me know what you think about this first change management flow case representation. I working on the next ones: non-interchangeable changes, renumbers (which I like to call Fork).
