---
title: "Thoughts about PLM Business models"
date: 2020-02-11
categories: 
  - "business-model"
coverImage: "AllIsometricSept-02.jpg"
---

When it comes to PLM, it is difficult to have a clear opinion on business models. These last few days I have seen multiple business models and pricing configuration from PLM software vendors. Let's review the different aspects of PLM business models.

## Subscription vs License

Let's get this one out of the way. Today Licenses are not the norm for new softwares. We don't buy softwares that much, we buy a service. You may argue, because you still have a few licenses you bought, but that's going to disappear sooner or later.

But it used to not only be a license, it use to be License + Maintenance. Then it has of course to be understood that Subscription must include both.

The next item in the subscription package is the upgrades. We know PLM tends to be very configured and editors are trying to make it as cheap as possible to upgrade. Aras made a difference by including their upgrades in the subscription. We will see then the impact on scalability.

_**My Own Opinion: Ideally a subscription should contain Right to use the software, Maintenance, Support and Access to upgrades.**_

## Per User vs User Packs

Lots of SaaS Solution are sold by the user. Everyone has to have a login so forget the floating licenses and just pay by the user. Makes a lot of sense to me.

The good thing about floating licenses was that you were actually paying for some sort of volume of usage. If a new employee got in, eventually they wouldn't need a new license right a way.

Some vendors sell "user packs". You have 200 users, then you buy the 250 users pack. It gives a great flexibility, no need to call purchasing for the next 50 new employee in the company, Yay ! WAIT, you know you actually pay 50 users more than you actually need, right?

Is the user the right metric? Could it be the API usage? Amazon Web Services can have very complex pricing (data-transfer, unused IP address, hours of cpu usage,...) but in the end, it is seen as efficiency, you know you pay for something you use.

_**My Own Opinion: whether it is invoiced by user or by usage the key proposal to me is to offer something flexible for which companies actually believe they can see a service scaling with the cost of their solution.**_

## All-Inclusive vs Module-based pricing

An all-access subscription versus Module Based subscription is an interesting topic because all-inclusive is always very appealing. If you stop here, there can't be much debate. Module-based just sounds complex, and you start thinking about the management you need to do in order to track all the modules your colleague use or need. All inclusive is a way better deal !!! WAIT AGAIN... let's try a scenario:

You bought a subscription all-inclusive, you haven't deployed everything and it comes to deploying Module X for which you saw demos but never really got into the implementation details yet. Imagine it doesn't work, or still need some adaptations. At this moment you have no power. It's like buying the whole Microsoft 365 package. You know you don't like Microsoft Teams, but you're somehow paying for it so unless you're [IBM](https://www.theverge.com/2020/2/10/21132060/ibm-slack-chat-employee-rollout-microsoft-teams-competition) you won't switch everyone to another solution !

Buying module per module gives you a control over your application scalability.

How do you scale down your application. Let's imagine you bought the whole solution with an all-inclusive solution. But some editor have a great job-specific application, much better than what's offered in your solution. How are you going to justify the cost of the better solution if there is no saving in front of it?

**_My Own Opinion: PLM can be so wide, that you can't have everything included in your subscription from day 1. It sounds appealing but, in terms of commercial relationship with your software vendor it's a huge risk._**

## Scalability

Scalability IS the key aspect of nowadays business model. How from day one can you offer a business model from 1 to 10 000 users (or 350 000 at IBM :) ). It doesn't have to be the same price per user, but how can you make a business model with which all size of companies can become a customer.

Part of this answer is the technology. If your upgrade process takes a fix amount of time, then including it in the subscription will tend the software vendor to move its focus to larger customers with larger subscriptions.

**_My Own Opinion: I started my IT career as an SAP FI/CO/PS consultant at Accenture. And I loved working on the controlling module where you actually do some engineering about product costing. The whole business model of a PLM solution has to make sense. Customers should be aware of it, some models may seem appealing, but the consequence may not be what you expected._**
