---
title: "Pains without a PLM"
date: 2018-09-06
categories: 
  - "business-consulting"
coverImage: "pain.jpg"
---

I'm always surprised to see how low the PLM adoption is. I have been in this industry for almost 10 years and I'm still entering meetings when most people are not aware, not only about PLM basic concepts, but also about any type of enhancement they could get in their daily work because of PLM. It's like the digitalization process going on everywhere could not be applied to their own business. Then a lot of our work as PLM consultants is about education.

The PLM initial education takes usually 2 complementary tracks:

- Expressing Pains
- Discovering Enhancement opportunities

I found this video of [Jim Brown from Tech-Clarity](https://tech-clarity.com/about/jim-brown) which lists 5 signs that you need PLM.

https://www.youtube.com/watch?v=fnEz8Fp40eo

# Pains

A real pain is typically something that you wake up with every morning. Ok, could be every once in a while when you face it, not necessarily every morning. But it is something that when it happens, you hoped things could work more efficiently and you believe that woud create value or reduce cost for the company. Let's review the pains Jim Brown listed in its video.

## Can't find documentation

This is not a PLM specific problem but it has been an important element when selling PLM/PDM to engineering department. The statistics on the non-productive time spent on searching for documentation.

> [Workers, on average, spend 36 percent of their day looking for and consolidating information. But 44 percent of the time, they can't find the information.](https://www.cmswire.com/information-management/information-management-the-critical-thing-youre-overlooking-in-the-digital-workplace/)

## Not sure what version of the product or document we are working on

One key aspect of PLM and document management is the versionning. When you are in an ERP you basicaly use item references and everybody usually reads the same information from this reference. With PLM you introduce revisionsso if you don't have the appropriate IT solutions to navigate these revisions, you end-up confused on wether or not you have the latest version of the document or the product.

## Where is the specification?

With more legal, faster changes, more actors in projects, specifications to meet become more and more tricky to track. Are you sure you are delivering a product that satisfies all the requirements. Lots of vehicule recall prove that this is not an easy thing to manage. You need the right IT stack and good practices to connect all the dots between Requirements and product design.

![specification](images/tree3-1024x773.jpg)

## Didn't we do something like this before

Re-use has always been a good reason to invest in PLM. The Europeans like have been told for years that it was a key aspect of Airbus success that from the A320 family to the A380, the flight deck were almost the same and re-use was a critical aspect of an aircraft program. the more complex the products become the more value you save by reusing parts.

[Read a presentation from LMI comparing Part Reuse Vs Part introduction.](http://www.dla.mil/Portals/104/Documents/LandAndMaritime/V/VA/PSMC/Apr12/LM_18PartsReuse_151030.pdf)

# Then?

Lots of companies would acknowledge this. The more we digitalize the business the more you will feel pain where a process is not digitalized yet or maybe not enough inter-connected with other businesses. Then the main activity to get things moving in your company is to build your business case. Build the material that will show to the management (for decision making) but also to every coworker (for engaging in a change) that you need to strenghen your PLM process and/or PLM tools.

Feel free to share additionnal **Pains** you identified in your company, at your customers !
